<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', function () {
//    return view('welcome');
//});

Auth::routes();
Auth::routes(['verify' => true]);
Route::group(['middleware' => ['auth']], function() {
    Route::get('all-reports', 'ReportController@all_reports');
     // media route
     Route::resource('media', 'MediaController');
     Route::resource('payment', 'PaymentController');
     Route::get('paymentstatus', 'PaymentController@paymentstatus')->name('payment.paymentstatus');
     Route::post('paymentstatusfiltered', 'PaymentController@paymentstatus')->name('payment.paymentstatus');
     Route::get('paymentstatusfiltered', 'PaymentController@paymentstatus')->name('payment.paymentstatus');
     Route::post('edit-paymentstatus', 'PaymentController@editpaymentstatus')->name('payment.edit-paymentstatus');
     Route::resource('withdraw', 'WithdrawController');
     Route::get('withdraw-detail/{id}','WithdrawController@detail')->name('withdraw.detail');
     Route::get('delete-withdraw/{id}','WithdrawController@destroy')->name('w.delete');
     Route::get('delete-payment/{id}','PaymentController@destroy')->name('p.delete');
     // Main features
    //  schools
    Route::resource('school','SchoolController');
    // state wise schools
    Route::get('state-wise-school/{state}','SchoolController@get_state_wise_school');
    Route::post('import-school','SchoolController@importSchool');
    Route::post('import-payment','PaymentController@importPayment');
    Route::get('export-school','SchoolController@exportSchool');

    // Route::resource('program-manager','ProgramManagerController');
   // cooks
    Route::resource('cooks','CooksController');
    // state wise cooks
    Route::get('state-wise-cook/{state}','CooksController@get_state_wise_cook');
    Route::post('import-cooks','CooksController@importCooks');
    Route::get('cooks-feeding-report/{id}','CooksController@feeding_report')->name('cooks.report');

    // aggregators
    Route::resource('aggregators','AggregatorController');
    // state wise aggregators
    Route::get('state-wise-aggregator/{state}','AggregatorController@get_state_wise_aggregator');
    Route::get('aggregators-feeding-report/{id}','AggregatorController@feeding_report')->name('aggregators.report');

    // feeding
    Route::resource('feedings','FeedingController');
    // state wise feeding
    Route::get('state-wise-feeding/{state}', 'FeedingController@get_state_wise_feeding');
    Route::get('pupils-request','FeedingController@pupils_request');
    Route::get('export-feeding', 'FeedingController@exportFeeding');
    Route::post('import-feeding', 'FeedingController@importFeeding');
    // request feeding list
    Route::get('feeding-report-request', 'FeedingController@feeding_report_request')->name('feedings.request_list');

    // blog/post
    Route::resource('posts', 'PostController');

    // notifications
    Route::get('notifications', 'ReportController@notification');

    // reports
    Route::get('report-form', 'ReportController@report_form');
    Route::get('report-details/{id}', 'ReportController@report_details');
    Route::post('submit-report-form', 'ReportController@prepare_report')->name('report.prepare');
    Route::post('paid-report-form', 'ReportController@paid_report')->name('report.paid');
    Route::post('date-wise-feeding-report', 'ReportController@date_wise_feeding_report');
    Route::post('state-admin-feeding-report', 'ReportController@state_admin_feeding_report');

    // activity logs
    Route::get('activity-logs', 'ReportController@activityLog');

    // Suspend management
    Route::post('suspend-request-confirm', 'SuspendManagementController@make_suspend_request');
    Route::get('suspend-requests', 'SuspendManagementController@index');
    Route::get('suspend-approved/{id}', 'SuspendManagementController@approve_suspend');
    Route::get('suspend-declined/{id}', 'SuspendManagementController@decline_suspend');
    Route::get('suspend-delete/{id}', 'SuspendManagementController@delete_suspend_request');

    // state admin list
    Route::get('state-admin', 'UserController@state_admin_list');
    Route::get('user-role/{role}', 'UserController@get_all_admin')->name('user-role');

    // state wise lga selection
    Route::get('get-lga', 'SchoolController@get_lga');

    // user profile
    Route::get('my-profile', 'UserController@user_profile');
    Route::get('change-password', 'UserController@get_pass_change_form');
    Route::put('save-new-password', 'UserController@save_changed_password');
    Route::put('save-profile-picture', 'UserController@save_profile_picture');

    // role permissions
    Route::resource('roles','RoleController');
    Route::resource('permissions','PermissionController');
    Route::resource('users','UserController');
});
Route::get('/home', 'HomeController@home')->name('home');
Route::get('/', 'HomeController@index')->name('index');

// blog details
Route::get('details/{slug}', 'PostController@post_details');

//clear cache
Route::get('clear-cache', function () {

    Artisan::call('cache:clear');
    Artisan::call('config:cache');

    dd("Cache is cleared");
});

Route::get('all-states', function () {
    return view('all-states');
});
Route::post('add-school', 'SchoolController@add_school')->name('add_school');
Route::get('state-governments/{id}', 'ReportController@state_gov');
Route::get('suggestions', 'SchoolController@suggestions');
Route::get('gov-school', 'SchoolController@get_gov_school')->name('gov_school');
Route::get('get-gov-school/{keyword}', 'SchoolController@get_gov_school_ajax')->name('gov_school_ajax');
Route::get('state-school/{id}', 'SchoolController@get_state_school');
Route::post('send-report', 'ReportController@report');
Route::get('delete-report/{id}', 'ReportController@delete');


Route::get('all-routes', function (){
    dd(Artisan::call('route:list'));
});
